FX_TYPES = {
	{
	id = "smoke",
	spriteNames = {"smoke_1","smoke_2","smoke_3","smoke_4","smoke_5","smoke_6","smoke_7"},
	friction = 1,
	getLife = function(self)
		return math.random() + 1
	end,
	getOpacity = function(self, prg)
		return 1-prg
	end,
	getScale = function(self, prg)
		return prg*2+0.5
	end,
	},
	{
	id = "explosion",
	spriteNames = {"explosionA","explosionB","explosionC","explosionD"},
	getRGB = function(self, prg)
		return 255,255,255
	end,
	sound = "explosion",
	friction = 1,
	spriteState = true,
	getLife = function(self)
		return 0.25
	end,
	},
	{
	id = "afterburn",
	spriteNames = {"afterBurn_1","afterBurn_2","afterBurn_flame_1","afterBurn_flame_2","afterBurn_flame_3"},
	},
	{
	id = "engine",
	spriteNames = {"lowBurn_1","lowBurn_2","lowBurn_3","lowBurn_4","lowBurn_flame_1","lowBurn_flame_2","lowBurn_flame_3","lowBurn_flame_4","lowBurn_glow_1","lowBurn_trail_1","lowBurn_trail_2",},
	},
	{
	id = "heat",
	spriteNames = {"reentry_burn_1","reentry_burn_2","reentry_burn_3"},
	},
	{
	id = "shotBlast",
	spriteState = true,
	flip = true,
	spriteNames = {"shotBlast"},
	getRGB = function(self, prg)
		return 255,255,255
	end,
	getLife = function(self)
		return 0.1
	end,
	friction = 1,
	spriteState = true,
	},
	{
	id = "nuke",
	spriteNames = {"nukeExplosion"},
	friction = 1,
	getLife = function(self)
		return 8
	end,
	getOpacity = function(self, prg)
		return 1-prg
	end,
	getScale = function(self, prg)
		return (1-prg)*10
	end,
	},
	
}


for index, def in ipairs(FX_TYPES) do
	FX_TYPES[def.id] = index
end


PROJECTILE_TYPES = {
	{
		id = "bullet", 
		spriteNames = {main = "shot"},
		mass = 1,
		health = 10, 
		airFriction = 60.8, 
		angleFriction = 0,
		radius = 16,
		getRGB = function(self, r,g ,b)
			local speed =math.distance(0,0,self.dx, self.dy)
			local light = math.min(1,speed/2000)*0.75 + 0.25
			return light*255,light*255,light*255
		end,
		angleAdjustment = 0.1,
		impulseDamageFactor = 0.01,
		events = {
			create = function(self)
				local fx = Fx:new(FX_TYPES.shotBlast, self.map, self.x, self.y, self.dx*0.25, self.dy*0.25)
				fx:setAngle(self.angle)
				fx:setOwner(self.owner, 0, 40)
				self:emitSound("gunFire", 1, 1)
			end,
			remove = function(self)
				for i=1,math.random(1,4) do
					local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*15, self.y+math.randomGaussian()*15, -self.dx*0.1+math.randomGaussian()*15, -self.dy*0.1+math.randomGaussian()*15)
					fx:setDelay((i-1)*0.1*math.random())
				end
				for i=1,math.random(1,3) do
					local fx = Fx:new(FX_TYPES.explosion, self.map, self.x+math.randomGaussian()*15, self.y+math.randomGaussian()*15, -self.dx*0.1+math.randomGaussian()*15, -self.dy*0.1+math.randomGaussian()*15)
					fx:setDelay((i-1)*0.1*math.random())
				end
			end,
		},
	},
}

for index, def in ipairs(PROJECTILE_TYPES) do
	PROJECTILE_TYPES[def.id] = index
end


MISSILE_TYPES = {
	{
		id = "basic", 
		spriteNames = {main = "missile"},
		targetDistance = 10000,
		targetArc = math.pi*0.25,
		trailDist = 20,
		mass = 1,
		maxDuration = 10,
		health = 10, 
		energy = 100, 
		flameSize =0.5,
		engineEnergyConsumption = 25,
		airFriction = 5.2, 
		angleFriction = 5,
		angleForwardFriction = 1,
		radius = 16,
		rudderArc = 0.1*math.pi,
		detonateOnHit = true,
		rudderFlowSize = 0.3,
		rudderNullify = 2.9,
		angleAdjustment = -0.1,
		enginePower = 3600,
		maxCarvingLoss =0.9,
		speedThresholdDamping =3000,
		engineResponsiveness = 212,
		rudderResponsiveness = 2,
		angleThrusters = 0.2,
		engineRudderArc = math.pi*0.04,
		engineRudderPower = 0.02,
		engineRudderResponsiveness = 0.5,
		carvingSpeedDamping = 0.2,
		carvingAngleDamping = 15.25,
		aerodynamicness = 0.99,
		aerodynamicExp = 3,
		bodyCarving = 0.003,
		carvingExp = 4,
		ignition = 0.2,
		explosionDamage = 75,
		explosionDamageExp = 1.5,
		explosionRadius = 800,
		explosionForce = 2400,
		impulseDamageFactor = 0.1,
		events = {
			create = function(self)
				self:emitSound("missileLaunch", 1, 1)
			end,
			remove = function(self)
				if self.health <= 0 then
					for i=1,math.random(13,17) do
						local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*15, self.y+math.randomGaussian()*15, -self.dx*0.01+math.randomGaussian()*1000, -self.dy*0.01+math.randomGaussian()*1000)
						fx:setDelay((i-1)*0.02*math.random())
						fx:setScale(2)
					end
					for i=1,math.random(15,17) do
						local fx = Fx:new(FX_TYPES.explosion, self.map, self.x+math.randomGaussian()*115, self.y+math.randomGaussian()*115, -self.dx*0.01+math.randomGaussian()*700, -self.dy*0.01+math.randomGaussian()*700)
						fx:setDelay((i-1)*0.02*math.random())
						fx:setScale(3)
					end
				end
			end,
		},
	},
	{
		id = "nuke", 
		spriteNames = {top = "icm_top", middle = "icm_middle", bottom = "icm_bottom"},
		offsets = {
			{sprite = "top", offset = 165},
			{sprite = "middle", offset = 0},
			{sprite = "bottom", offset = -232},
		},
		spawnInGround = true,
		flameSize = 3,
		warning = true,
		spriteAngle = math.pi*0.5,
		minTargetSpeed = 750,
		targetBuilding = true,
		targetDistance = 100000,
		targetAboveFactor = 0.9,
		targetAboveThreshold = 15000,
		targetArc = math.pi*2,
		trailDist = 390,
		maxDuration = 200,
		mass = 300,
		stepType = "nukeHalf",
		stepOffset = 165/2,
		health = 1500, 
		energy = 400,
		engineEnergyConsumption = 25,
		airFriction = 15.2, 
		angleFriction = 55,
		angleForwardFriction = 2,
		radiusY = 90,
		radiusX = 600,
		rudderArc = 0,
		rudderFlowSize = 0,
		rudderNullify = 1,
		angleAdjustment = 0.1,
		enginePower = 900,
		maxCarvingLoss =0.1,
		speedThresholdDamping = 3000,
		engineResponsiveness = 10,
		rudderResponsiveness = 1,
		angleThrusters = 5,
		engineRudderArc = math.pi*0.05,
		engineRudderPower = 0.001,
		engineRudderResponsiveness = 0.75,
		carvingSpeedDamping = 0.2,
		carvingAngleDamping = 125.25,
		aerodynamicness = 0.99,
		aerodynamicExp = 1.5,
		bodyCarving = 0.004,
		carvingExp = 2,
		ignition = 0,
		explosionDamage = 3000,
		explosionDamageExp = 1,
		explosionRadius = 20000,
		explosionForce = 10000,
		impulseDamageFactor = 0.1,
		events = {
			create = function(self)
				sound.playSound("missileLaunchDetected", 1, 0, 1)
			end,
			remove = function(self)
				if self.health <= 0 then
					self:emitSound("bigblast")
					local fx = Fx:new(FX_TYPES.nuke, self.map, self.x, self.y, 0, 0)
					states.get("game").whiteOut = 3
					for i=1,math.random(13,17) do
						local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*15, self.y+math.randomGaussian()*15, -self.dx*0.01+math.randomGaussian()*1000, -self.dy*0.01+math.randomGaussian()*1000)
						fx:setDelay((i-1)*0.02*math.random())
						fx:setScale(2)
					end
					for i=1,math.random(15,17) do
						local fx = Fx:new(FX_TYPES.explosion, self.map, self.x+math.randomGaussian()*115, self.y+math.randomGaussian()*115, -self.dx*0.01+math.randomGaussian()*700, -self.dy*0.01+math.randomGaussian()*700)
						fx:setDelay((i-1)*0.02*math.random())
						fx:setScale(3)
					end
				end
			end,
		},
	},
	{
		id = "nukeHalf", 
		spriteNames = {top = "icm_top", middle = "icm_middle", bottom = "icm_bottom"},
		offsets = {
			{sprite = "top", offset = 165/2},
			{sprite = "middle", offset = -165/2},
		},
		flameSize = 3,
		spriteAngle = math.pi*0.5,
		trailDist = 260,
		warning = true,
		stepType = "nukeWarhead",
		stepOffset = 165/2,
		minTargetSpeed = 0,
		targetBuilding = true,
		targetDistance = 100000,
		targetAboveFactor = 0.6,
		targetAboveThreshold = 20000,
		targetArc = math.pi*2,
		maxDuration = 200,
		energy = 200, 
		mass = 150,
		health = 1200, 
		engineEnergyConsumption = 25,
		airFriction = 10.2, 
		angleFriction = 34,
		angleForwardFriction = 1,
		radiusY = 90,
		radiusX = 400,
		rudderArc = 0,
		rudderFlowSize = 0,
		rudderNullify = 1,
		angleAdjustment = 0.05,
		enginePower = 1500,
		maxCarvingLoss =0.1,
		speedThresholdDamping = 3000,
		engineResponsiveness = 10,
		rudderResponsiveness = 1,
		angleThrusters = 20,
		engineRudderArc = math.pi*0.05,
		engineRudderPower = 0.004,
		engineRudderResponsiveness = 0.75,
		carvingSpeedDamping = 0.2,
		carvingAngleDamping = 35.25,
		aerodynamicness = 0.9,
		aerodynamicExp = 1,
		bodyCarving = 0.004,
		carvingExp = 2,
		ignition = 0,
		explosionDamage = 3000,
		explosionDamageExp = 1,
		explosionRadius = 20000,
		explosionForce = 10000,
		impulseDamageFactor = 0.1,
		events = {
			remove = function(self)
				if self.health <= 0 then
					self:emitSound("bigblast")
					local fx = Fx:new(FX_TYPES.nuke, self.map, self.x, self.y, 0, 0)
					states.get("game").whiteOut = 3
					for i=1,math.random(13,17) do
						local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*15, self.y+math.randomGaussian()*15, -self.dx*0.01+math.randomGaussian()*1000, -self.dy*0.01+math.randomGaussian()*1000)
						fx:setDelay((i-1)*0.02*math.random())
						fx:setScale(2)
					end
					for i=1,math.random(15,17) do
						local fx = Fx:new(FX_TYPES.explosion, self.map, self.x+math.randomGaussian()*115, self.y+math.randomGaussian()*115, -self.dx*0.01+math.randomGaussian()*700, -self.dy*0.01+math.randomGaussian()*700)
						fx:setDelay((i-1)*0.02*math.random())
						fx:setScale(3)
					end
				end
			end,
		},
	},
	{
		id = "nukeWarhead", 
		spriteNames = {top = "icm_top"},
		offsets = {
			{sprite = "top", offset = 0},
		},
		flameSize = 3,
		spriteAngle = math.pi*0.5,
		minTargetSpeed = 0,
		warning = true,
		targetBuilding = true,
		targetDistance = 100000,
		targetAboveFactor = 0.2,
		targetAboveThreshold = 30000,
		targetArc = math.pi*2,
		trailDist = 190,
		maxDuration = 200,
		mass = 100,
		health = 800, 
		energy = 2000, 
		engineEnergyConsumption = 25,
		airFriction = 5.2, 
		angleFriction = 15,
		angleForwardFriction = 0.5,
		radiusY = 90,
		radiusX = 200,
		rudderArc = 0,
		rudderFlowSize = 0,
		rudderNullify = 1,
		angleAdjustment = 0.01,
		enginePower = 3900,
		maxCarvingLoss =0.1,
		speedThresholdDamping = 3000,
		engineResponsiveness = 10,
		rudderResponsiveness = 1,
		angleThrusters = 155,
		engineRudderArc = math.pi*0.05,
		engineRudderPower = 0.01,
		engineRudderResponsiveness = 0.75,
		carvingSpeedDamping = 0.2,
		carvingAngleDamping = 25.25,
		aerodynamicness = 0.999,
		aerodynamicExp = 2,
		bodyCarving = 0.008,
		carvingExp = 2,
		ignition = 0,
		explosionDamage = 3000,
		explosionDamageExp = 1,
		explosionRadius = 20000,
		explosionForce = 10000,
		impulseDamageFactor = 0.1,
		events = {
			remove = function(self)
				if self.health <= 0 then
					self:emitSound("bigblast")
					local fx = Fx:new(FX_TYPES.nuke, self.map, self.x, self.y, 0, 0)
					states.get("game").whiteOut = 3
					for i=1,math.random(13,17) do
						local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*15, self.y+math.randomGaussian()*15, -self.dx*0.01+math.randomGaussian()*1000, -self.dy*0.01+math.randomGaussian()*1000)
						fx:setDelay((i-1)*0.02*math.random())
						fx:setScale(2)
					end
					for i=1,math.random(15,17) do
						local fx = Fx:new(FX_TYPES.explosion, self.map, self.x+math.randomGaussian()*115, self.y+math.randomGaussian()*115, -self.dx*0.01+math.randomGaussian()*700, -self.dy*0.01+math.randomGaussian()*700)
						fx:setDelay((i-1)*0.02*math.random())
						fx:setScale(3)
					end
				end
			end,
		},
	},
}

for index, def in ipairs(MISSILE_TYPES) do
	MISSILE_TYPES[def.id] = index
end


SHIP_TYPES = {
	{	
		id = "centurion",
		health = 10,
		healthRegain = 0.3,
		mass = 10,
		trailDist = 50,
		collisionThreshold = 0,
		collisionDamageFactor = 0.1,
		engineResponsiveness = 2,
		enginePower = 480,
		boostBonus = 2,
		energy = 100,
		recharge = 30,
		boostDrain = 25,
		rollResponsiveness = 4,
		rollRestoration = 10,
		rollSpeed = 10,
		engineRudderArc = math.pi*0.02,
		engineRudderPower = 0.02,
		engineRudderResponsiveness = 15,
		rudderResponsiveness = 5,
		rudderNullify = 0.4,
		rudderArcUp = math.pi*0.2,
		rudderArcDown = math.pi*0.1,
		rudderFlowSize = 0.24,
		bodyCarving = 0.02,
		speedThresholdDamping =3000,
		carvingAngleDamping =7.25,
		carvingSpeedDamping =0.75,
		maxCarvingLoss =0.4,
		carvingExp = 3,
		flatFactor = 0.95,
		airFriction = 3,
		radius = 48,
		angleAdjustment = 0.01,
		angleFriction = 2,
		angleForwardFriction = 0.25,
		angleThrusters = 2.6,
		aerodynamicness = 0.999,
		aerodynamicExp = 2,
		resourceSpacing = 250,
		resourceRubberDist = 500,
		resourceForce = 500,
		resourceFrictionAmount = 2,
		resourceMatchAmount = 0.5,
		impulseDamageFactor = 0.01,
		explosionDamage = 175,
		explosionDamageExp = 1.2,
		explosionRadius = 500,
		explosionForce = 500,
		spriteNames = {
			bodySide 	= "mojamDaisy_bodySide_1",
			bodyTop  	= "mojamDaisy_bodyTop_1",
			cockpitSide = "mojamDaisy_cockpitSide_1",
			cockpitTop 	= "mojamDaisy_cockpitTop_1",
			engineSide 	= "mojamDaisy_engineSide_1",
			engineTop 	= "mojamDaisy_engineTop_1",
			wingSide 	= "mojamDaisy_wingSide_1",
			wingTop 	= "mojamDaisy_wingTop_1",
		},
		pieces = {
			wingA = {x = -20, y = 8, z = -22, sprite = "wing", angle = math.pi, rudder = -0.6},
			body = 	{x = 0, y = 0, z = 0, sprite = "body", flip = true,},
			flameA = {x = -92, y = -9, z = -5, flame = true, flip = true, rudder = 0.2},
			engine = {x = -53, y = -9, z = 0, sprite = "engine", flip = true, rudder = 0.2},
			flameB = {x = -92, y = -9, z = 5, flame = true, flip = true, rudder = 0.2},
			cockpit = {x = -22, y = -13, z = 0, sprite = "cockpit", flip = true,},
			wingB = {x = -20, y = 8, z = 22, sprite = "wing", flip = true, rudder = -0.6},
		},
		renderOrders = {
			{"wingA", "engine", "cockpit", "body", "wingB", "flameA", "flameB"},
			{"engine","body", "wingB","wingA","cockpit" , "flameA", "flameB"},
			{"wingB","engine", "cockpit", "body", "wingA", "flameB", "flameA"},
			{"engine","cockpit","wingA","wingB", "body", "flameB", "flameA"},
		},
		weapons = {
			{name = "babom", projectile = PROJECTILE_TYPES.bullet, launchSpeed = 6000, energy = 6, delay = 0.07},
			{name = "homy", missile = MISSILE_TYPES.basic, launchSpeed = 300, launchAngle = math.pi*0.5, energy = 35, delay = 0.15},
		},
		events = {
			remove = function(self)
				for i=1,math.random(6,18) do
					local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*100, self.y+math.randomGaussian()*100, self.dx+math.randomGaussian()*300, self.dy+math.randomGaussian()*300)
					fx:setDelay((i-1)*0.1*math.random())
					fx:setScale(5)
				end
				for i=1,math.random(8,18) do
					local fx = Fx:new(FX_TYPES.explosion, self.map, self.x+math.randomGaussian()*150, self.y+math.randomGaussian()*150, self.dx+math.randomGaussian()*550, self.dy+math.randomGaussian()*550)
					fx:setDelay((i-1)*0.1*math.random())
					fx:setScale(3)
				end
			end,
		}
	},
	{	
		id = "falcon",
		health = 10,
		healthRegain = 0.3,
		mass = 10,
		trailDist = 50,
		collisionThreshold = 0,
		collisionDamageFactor = 0.1,
		engineResponsiveness = 2,
		enginePower = 480,
		boostBonus = 2,
		energy = 100,
		recharge = 30,
		boostDrain = 25,
		rollResponsiveness = 4,
		rollRestoration = 10,
		rollSpeed = 10,
		engineRudderArc = math.pi*0.02,
		engineRudderPower = 0.02,
		engineRudderResponsiveness = 15,
		rudderResponsiveness = 5,
		rudderNullify = 0.4,
		rudderArcUp = math.pi*0.2,
		rudderArcDown = math.pi*0.1,
		rudderFlowSize = 0.24,
		bodyCarving = 0.02,
		speedThresholdDamping =3000,
		carvingAngleDamping =7.25,
		carvingSpeedDamping =0.75,
		maxCarvingLoss =0.4,
		carvingExp = 3,
		flatFactor = 0.95,
		airFriction = 3,
		radius = 48,
		angleAdjustment = 0.01,
		angleFriction = 2,
		angleForwardFriction = 0.25,
		angleThrusters = 2.6,
		aerodynamicness = 0.999,
		aerodynamicExp = 2,
		resourceSpacing = 250,
		resourceRubberDist = 500,
		resourceForce = 500,
		resourceFrictionAmount = 2,
		resourceMatchAmount = 0.5,
		impulseDamageFactor = 0.01,
		explosionDamage = 175,
		explosionDamageExp = 1.2,
		explosionRadius = 500,
		explosionForce = 500,
		spriteNames = {
			bodySide 	= "mojamFalcon_bodySide_1",
			bodyTop  	= "mojamFalcon_bodyTop_1",
			cockpitSide = "mojamFalcon_cockpitSide_1",
			cockpitTop 	= "mojamFalcon_cockpitTop_1",
			engineSide 	= "mojamFalcon_engineSide_1",
			engineTop 	= "mojamFalcon_engineTop_1",
			wingSide 	= "mojamFalcon_wingASide_1",
			wingTop 	= "mojamFalcon_wingATop_1",
		},
		pieces = {
			wingA = {x = -8, y = 3, z = -50, sprite = "wing", flip = true, rudder = -0.6},
			body = 	{x = 0, y = 0, z = 0, sprite = "body", flip = true,},
			flameA = {x = -63, y = -15, z = 0, flame = true, flip = true, rudder = -0.2},
			engine = {x = -33, y = 2, z = 0, sprite = "engine", flip = true, rudder = -0.2},
			flameB = {x = -63, y = 15, z = 0, flame = true, flip = true, rudder = -0.2},
			cockpit = {x = -15, y = -11, z = 0, sprite = "cockpit", flip = true,},
			wingB = {x = -8, y = 3, z = 50, sprite = "wing", flip = true, rudder = -0.6},
		},
		renderOrders = {
			{"wingA", "engine", "cockpit", "body", "wingB", "flameA", "flameB"},
			{"engine","body", "wingB","wingA","cockpit" , "flameA", "flameB"},
			{"wingB","engine", "cockpit", "body", "wingA", "flameB", "flameA"},
			{"engine","cockpit","wingA","wingB", "body", "flameB", "flameA"},
		},
		weapons = {
			{name = "babom", projectile = PROJECTILE_TYPES.bullet, launchSpeed = 6000, energy = 6, delay = 0.07},
			{name = "homy", missile = MISSILE_TYPES.basic, launchSpeed = 300, launchAngle = math.pi*0.5, energy = 35, delay = 0.15},
		},
		events = {
			remove = function(self)
				for i=1,math.random(6,18) do
					local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*100, self.y+math.randomGaussian()*100, self.dx+math.randomGaussian()*300, self.dy+math.randomGaussian()*300)
					fx:setDelay((i-1)*0.1*math.random())
					fx:setScale(5)
				end
				for i=1,math.random(8,18) do
					local fx = Fx:new(FX_TYPES.explosion, self.map, self.x+math.randomGaussian()*150, self.y+math.randomGaussian()*150, self.dx+math.randomGaussian()*550, self.dy+math.randomGaussian()*550)
					fx:setDelay((i-1)*0.1*math.random())
					fx:setScale(3)
				end
			end,
		}
	}
}


for index, def in ipairs(SHIP_TYPES) do
	SHIP_TYPES[def.id] = index
end


ASTEROID_TYPES = {
	{
		id = "small", 
		spriteNames = {"asteroid_small_1",
						"asteroid_small_2",
						"asteroid_small_3",
						"asteroid_small_4",
						"asteroid_small_5",
						"asteroid_small_6",
						"asteroid_small_7",
						"asteroid_small_8",},
		mass = 1,
		health = 10, 
		airFriction = 5.2, 
		angleFriction = 5,
		radius = 20,
		angleAdjustment = 0,
		collisionThreshold = 0,
		impulseDamageFactor = 0.01,
		events = {
			remove = function(self)
				for i=1,math.random(5,7) do
					local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*self:getRadius(), self.y+math.randomGaussian()*self:getRadius(), self.dx*0.55+math.randomGaussian()*100, self.dy*0.55+math.randomGaussian()*100)
					fx:setDelay((i-1)*0.01*math.random())
					fx:setScale(1)
				end
			end,
		},
	},
	{
		id = "medium", 
		spriteNames = {"asteroid_medium_1",
						"asteroid_medium_2",
						"asteroid_medium_3",
						"asteroid_medium_4",
						"asteroid_medium_5",
						"asteroid_medium_6",
						"asteroid_medium_7",},

		subAmount = 2,
		subType = "small",
		subSpread = 500,
		mass = 15,
		health = 50, 
		airFriction = 5.2, 
		angleFriction = 5,
		radius = 30,
		angleAdjustment = 0,
		collisionThreshold = 0,
		impulseDamageFactor = 0.05,
		events = {
			remove = function(self)
				for i=1,math.random(9,12) do
					local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*self:getRadius(), self.y+math.randomGaussian()*self:getRadius(), self.dx*0.55+math.randomGaussian()*200, self.dy*0.55+math.randomGaussian()*200)
					fx:setDelay((i-1)*0.01*math.random())
					fx:setScale(2)
				end
			end,
		},
	},
	{
		id = "large", 
		spriteNames = {"asteroid_large_1",
						"asteroid_large_2",
						"asteroid_large_3",
						"asteroid_large_4",
						"asteroid_large_5",
						"asteroid_large_6",},
		subAmount = 2,
		subType = "medium",
		subSpread = 2000,
		mass = 150,
		health = 150, 
		airFriction = 5.2, 
		angleFriction = 5,
		radius = 105,
		angleAdjustment = 0,
		collisionThreshold = 0,
		impulseDamageFactor = 0.1,
		resourceType = "plutonium",
		resourceAmount = 1,
		events = {
			remove = function(self)
				for i=1,math.random(15,29) do
					local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*self:getRadius(), self.y+math.randomGaussian()*self:getRadius(), self.dx*0.55+math.randomGaussian()*600, self.dy*0.55+math.randomGaussian()*600)
					fx:setDelay((i-1)*0.01*math.random())
					fx:setScale(3)
				end
			end,
		},
	},
}

for index, def in ipairs(ASTEROID_TYPES) do
	ASTEROID_TYPES[def.id] = index
end




RESOURCE_TYPES = {
	{
		id = "plutonium", 
		spriteNames = {main = "plutonium_ball",
						nuc = "plutonium_nuclei"},
		mass = 5,
		health = 200,
		healthDrainThreshold = 175,
		healthDrainSpeed = 75,
		airFriction = 15.2, 
		angleFriction = 5,
		radius = 40,
		collectionDistance = 400,
		suckDistance = 1500,
		suckReachDistance = 250,
		suckPower = 8000,
		suckSpeed = 8000,
		suckFriction = 6.75,
		angleAdjustment = 0,
		healthDropThreshold = 100,
		collisionThreshold = 25,
		collisionDamageFactor = 0.05,
		impulseDamageFactor = 0.01,
		explosionDamage = 75,
		explosionDamageExp = 1.5,
		explosionRadius = 1600,
		explosionForce = 2000,

		events = {
			remove = function(self)
				if self.health <= 0 then
					for i=1,math.random(12,22) do
						local fx = Fx:new(FX_TYPES.smoke, self.map, self.x+math.randomGaussian()*self:getRadius()+math.randomGaussian()*350, self.y+math.randomGaussian()*self:getRadius()+math.randomGaussian()*350, math.randomGaussian()*850, math.randomGaussian()*850)
						fx:setDelay((i-1)*0.01*math.random())
						fx:setScale(2)
					end
					for i=1,math.random(12,28) do
						local fx = Fx:new(FX_TYPES.explosion, self.map, self.x+math.randomGaussian()*350, self.y+math.randomGaussian()*350, math.randomGaussian()*850, math.randomGaussian()*850)
						fx:setDelay((i-1)*0.05*math.random())
						fx:setScale(3)
					end
				end
			end,
		},
	},
}


for index, def in ipairs(RESOURCE_TYPES) do
	RESOURCE_TYPES[def.id] = index
end



TEAM_TYPES = {
	{
		id = "mojans",
		shipType = "falcon",
		color = {r = 93, g = 223, b = 251},
	},
	{
		id = "daisies",
		shipType = "centurion",
		color = {r = 255, g = 221, b = 109},
	},
}

for index, def in ipairs(TEAM_TYPES) do
	TEAM_TYPES[def.id] = index
end